attribute vec3 aVertexPosition;
attribute vec2 aTextureCoord;

uniform float uXoffset;
uniform float uYoffset;
uniform float uScaleX;
uniform float uScaleY;
uniform float uFlip;
uniform vec2 uRotation;

uniform vec2 uResolution;

varying vec2 vTextureCoord;

void main(void) {

	vec3 vertex_pos = aVertexPosition;// / vec3(uResolution.x, uResolution.y, 1.0);

	vertex_pos = vertex_pos + vec3(uXoffset, uYoffset, 0.0);

	vertex_pos.x = vertex_pos.x * uScaleX * uResolution.x / uResolution.y;
	vertex_pos.y = vertex_pos.y * uScaleY;

	//vertex_pos = vertex_pos + vec3(uXoffset, uYoffset, 0.0);

	vec3 pos = vec3(
	 	vertex_pos.x * uRotation.y + vertex_pos.y * uRotation.x,
	 	vertex_pos.y * uRotation.y - vertex_pos.x * uRotation.x, 0.0);

	pos = pos / vec3(uResolution.x / uResolution.y, 1.0, 1.0);

	pos.y = pos.y * uFlip;

	//pos = pos + vec3(uXoffset, uYoffset, 0.0);

	gl_Position = vec4(pos, 1.0);

	vTextureCoord = aTextureCoord;

}